✅ Improved Outline: Gemini Memory Bank System

I. Introduction

Purpose of Gemini Memory Bank
The AI memory reset problem
Why structured documentation is the solution
Compatibility with KiloCode


II. Core Philosophy

Memory resets between sessions
Memory Bank is mission-critical
All tasks begin with reading all memory bank files
Status indicators: [Memory Bank: Active], [Partial], [Missing]

III. Memory Bank Folder Structure

Exact path required: .kilocode/rules/memory-bank/
Markdown format (.md)
Version-controllable, human-readable
No alternative folders allowed

IV. Required Core Files (5)

brief.md (Developer-owned)

Project overview, goals, technologies, significance
Never edited by Gemini
Template used if empty

product.md

Problem, solution, audience, features, UX goals, metrics
Derived from brief.md


context.md

Current focus, recent changes, next steps, blockers, decisions
Updated after every task


architecture.md

System design, file paths, component relationships, data flow
Must use real paths, no placeholders


tech.md

Languages, frameworks, versions, tools, constraints
Based on actual config files


V. Optional Files

tasks.md: Documented workflows for repeatable tasks
Subfolders:

features/, integrations/, api/, testing/, deployment/, database/


VI. Status Indicators

Must appear at start of every response
Format: [Memory Bank: Active] Brief summary
Used to confirm context loading


VII. Core Workflows

Initialization

Trigger: initialize memory bank
Deep analysis of codebase, config, docs, dependencies
Create all core files
Provide summary and request user verification


Regular Task Execution

Read all memory bank files
Synthesize understanding
Check for matching tasks in tasks.md
Execute task using memory bank context
Update context.md
Suggest task documentation if pattern detected


Update Memory Bank

Trigger: update memory bank
Review all files and project changes
Update all relevant files
Summarize changes


Document Repetitive Tasks

Trigger: add task or store this as a task
Create/update tasks.md
Use structured template
Confirm with developer

VIII. Behavioral Rules

Always read all files before any task
Never edit brief.md
Use real paths and verify existence
Be factual, systematic, and thorough
Acknowledge uncertainty and ask for clarification


IX. Error Handling

Missing folder or files → show [Memory Bank: Missing]
Partial files → show [Memory Bank: Partial]
Inconsistencies → prioritize brief.md, ask for clarification

X. Context Window Management

Memory Bank consumes tokens at session start
Suggest update + restart when context fills
Reload memory bank in new session


XI. Gemini-Specific Capabilities

Long context window
Deep code understanding
Multimodal support
Advanced reasoning
Full compatibility with KiloCode


XII. Final Reminders

Memory Bank is Gemini’s only persistent link
Quality of documentation = quality of collaboration
Every file, path, and update matters


XIII. End-of-File Marker

All .md files must end with:
# End-of-File (EOF), YYYY-MM-DD HH:MM:SS